#include <windows.h>
#include "win32.hpp"

extern int OPENGL_XRES;
extern int OPENGL_YRES;
extern bool OPENGL_FULLSCREEN;

LRESULT CALLBACK WndProc (HWND hwnd, UINT iMsg, WPARAM wParam, LPARAM lParam);

Window::Window()
{
}

Window::~Window()
{
}

bool Window::create(bool bflag)
{

	DWORD dwExStyle = WS_EX_APPWINDOW | WS_EX_WINDOWEDGE;
	DWORD dwStyle = WS_OVERLAPPEDWINDOW;	

    WNDCLASS wc;
		
	hInstance = GetModuleHandle(NULL);
	
	wc.style = CS_HREDRAW | CS_VREDRAW | CS_OWNDC; 
	wc.lpfnWndProc = (WNDPROC)WndProc;
	wc.cbClsExtra = 0;
	wc.cbWndExtra = 0;
	wc.hInstance = hInstance;
	wc.hIcon = LoadIcon(hInstance, IDI_APPLICATION);
	wc.hCursor = LoadCursor(NULL, IDC_ARROW);
	wc.hbrBackground = NULL;
	wc.lpszMenuName = NULL;
	wc.lpszClassName = "OpenGL";

	if(!RegisterClass(&wc)) return false;

	RtlZeroMemory(&screenSettings, sizeof(screenSettings));
	p.nSize = sizeof(PIXELFORMATDESCRIPTOR);
	p.nVersion = 1;
	p.dwFlags=PFD_DRAW_TO_WINDOW|PFD_SUPPORT_OPENGL|PFD_DOUBLEBUFFER;
	p.iPixelType=PFD_TYPE_RGBA;
	p.cColorBits=32;
	p.cDepthBits=16;
	p.iLayerType=PFD_MAIN_PLANE;

	RtlZeroMemory(&screenSettings, sizeof(screenSettings));
	screenSettings.dmSize = sizeof(screenSettings);
	screenSettings.dmPelsWidth = OPENGL_XRES;
	screenSettings.dmPelsHeight = OPENGL_YRES;
	screenSettings.dmBitsPerPel = 32;
	screenSettings.dmFields = DM_BITSPERPEL|DM_PELSWIDTH|DM_PELSHEIGHT;
	
	if(bflag)
	{
		dwExStyle = WS_EX_APPWINDOW;
		dwStyle = WS_POPUP | WS_CLIPSIBLINGS | WS_CLIPCHILDREN;
	}
	if (OPENGL_FULLSCREEN)
	{
		DEVMODE dmScreenSettings;					// Device Mode
		memset(&dmScreenSettings,0,sizeof(dmScreenSettings));		// Makes Sure Memory's Cleared
		dmScreenSettings.dmSize=sizeof(dmScreenSettings);		// Size Of The Devmode Structure
		dmScreenSettings.dmPelsWidth	= OPENGL_XRES;			// Selected Screen Width
		dmScreenSettings.dmPelsHeight	= OPENGL_YRES;			// Selected Screen Height
		dmScreenSettings.dmBitsPerPel	= 32;				// Selected Bits Per Pixel
		dmScreenSettings.dmFields=DM_BITSPERPEL|DM_PELSWIDTH|DM_PELSHEIGHT;

		if (ChangeDisplaySettings(&dmScreenSettings,CDS_FULLSCREEN)!=DISP_CHANGE_SUCCESSFUL)
			return false;

		dwExStyle=WS_EX_APPWINDOW;					// Window Extended Style
		dwStyle=WS_POPUP;						// Windows Style
	}
	
	hwnd = CreateWindowEx(dwExStyle, "OpenGL", "Fiat Homo", dwStyle, 0, 0, OPENGL_XRES, OPENGL_YRES, NULL, NULL, hInstance, NULL);
	hdc = GetDC(hwnd);
		
	pixelformat = ChoosePixelFormat(hdc, &p);
	SetPixelFormat(hdc, pixelformat, &p);
	hrc = wglCreateContext(hdc);
	wglMakeCurrent(hdc, hrc);
	if (OPENGL_FULLSCREEN)
		ShowCursor(FALSE);						// Hide Mouse Pointer
	else
		ShowCursor(true);

	ShowWindow(hwnd, SW_SHOW);			// iCmdShow kertoo ikkunan tilasta (koot yms);	
	SetForegroundWindow(hwnd);			// aseta plimmiseksi ikkunaksi, lismll sen prioriteettia
	SetFocus(hwnd);						// asettaa nppiksen keskittymn thn ikkunaan

	return true;
}

void Window::shut()
{
	ChangeDisplaySettings(NULL, 0);
	ReleaseDC(hwnd, hdc);
	DestroyWindow(hwnd);
}

HDC Window::getDC()
{
	return hdc;
}

LRESULT CALLBACK WndProc (HWND hwnd, UINT iMsg, WPARAM wParam, LPARAM lParam)
{			
	switch(iMsg)	// Ikkuna viestit
	{
		case WM_SYSCOMMAND:						// systeemi kskyt
		{
			switch (wParam)						// tarkistetaan
			{
				case SC_SCREENSAVE:				// yrittk ruudunsstj kynnisty
				case SC_MONITORPOWER:			// monitori yritt sst virtaa
				return 0;						// ei saat tapahtua
			}		
			break;									
		} break;

		case WM_CLOSE:		// Ikkuna on suljettu -> tapa se!!!
		{
				PostQuitMessage(0);
				return 0;
		} break;		
	}	

	// ei ksitellyt viestit hoitaa wintoosa... great X)
	return DefWindowProc(hwnd, iMsg, wParam, lParam);
}